IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Mail_Enviar_CleverAPI') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Mail_Enviar_CleverAPI
END
GO

CREATE PROCEDURE [dbo].[CPJ_Mail_Enviar_CleverAPI] @pJson VARCHAR(8000)
AS
SET NOCOUNT ON

	-------------------------------------------- VARIABLES RECIBIDAS POR PARAM --------------------------------------------

	DECLARE @pFrom					VARCHAR(8000)
	DECLARE @pTo					VARCHAR(8000)
	DECLARE @pSubject				VARCHAR(8000)
	DECLARE @pBody					VARCHAR(8000)
	DECLARE @pOmitir_Resultado_OK	TINYINT

	SET @pFrom						= ISNULL(CONVERT(VARCHAR(MAX), dbo.CF_JSON_VALUE(@pJson,'from')), '')
	SET @pTo						= ISNULL(CONVERT(VARCHAR(MAX), dbo.CF_JSON_VALUE(@pJson,'to')), '')
	SET @pSubject					= ISNULL(CONVERT(VARCHAR(MAX), dbo.CF_JSON_VALUE(@pJson,'subject')), '')
	SET @pBody						= ISNULL(CONVERT(VARCHAR(MAX), dbo.CF_JSON_VALUE(@pJson,'body')), '')
	SET @pOmitir_Resultado_OK		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Omitir_Resultado_OK')), 0)

	-------------------------------------------- FIN VARIABLES RECIBIDAS POR PARAM --------------------------------------------

	-------------------------------------------- VARIABLES LOCALES --------------------------------------------

	DECLARE @pJson_A_Enviar		VARCHAR(8000)
	
	DECLARE @Respuesta TABLE (
								Respuesta		VARCHAR(1000),
								Rta_Estado		VARCHAR(1000)
							  )

	-------------------------------------------- FIN VARIABLES LOCALES --------------------------------------------

BEGIN TRY

	SET @pJson_A_Enviar =	'{' + 
							dbo.CF_Json_ParsearVariable('ModoDebug', '1', 'INTEGER') + ',' + 
							dbo.CF_Json_ParsearVariable('API_Metodo', 'mail_send_club', 'VARCHAR(MAX)') + ',' + 
							'"API_Data":{"from":"' + @pFrom + '","to":"' + @pTo + '","bcc":"","subject":"' + @pSubject + '","body":"' + @pBody + '","reply":""}' +
							'}'

	INSERT INTO @Respuesta
	EXEC dbo.CPJ_CleverAPI_Ejecutar @pJson_A_Enviar
	

	IF(@pOmitir_Resultado_OK = 0)
	BEGIN
		SELECT* FROM  @Respuesta
	END
END TRY
BEGIN CATCH

	EXECUTE usp_GetErrorInfo
	RETURN 9999

END CATCH